#
# 2021-03-04
#
# SpaceX Launch Display, by Anne Barela November 2020
# MIT License - for Adafruit Industries LLC
# See https://github.com/r-spacex/SpaceX-API for API info
#
# ReMix to add RocketLaunch data as an alternative launch calendar
# added time zone determinations for USA
# set 24 hour clock
# calculated wake-up for 00:20 reload
# setup leap year claculations
#

import time
import terminalio
from adafruit_magtag.magtag import MagTag
# import rtc

#
# Get wifi details and more from a secrets.py file
#
try:
    from secrets import secrets
except ImportError:
    print("WiFi secrets are kept in secrets.py, please add them there!")
    raise

months = ["January", "February", "March", "April", "May", "June", "July",
          "August", "September", "October", "November", "December"]
USE_24HR_TIME = True

# in seconds, we can refresh about 100 times on a battery
# TIME_BETWEEN_REFRESHES = 24 * 60 * 60  # once a day delay
NAP_TIME = 24 * 60 * 60  # re-calculated in take_a_nap(NAP_TIME)

# Set up data location and fields
DATA_SOURCE_TIME = "http://worldtimeapi.org/api/timezone/" + secrets["timezone"]
DATA_SOURCE_ROCKET = "https://fdo.rocketlaunch.live/json/launches/next"
DETAIL_LOCATION_R = ['result']  # launch_description
NAME_LOCATION_R = ['result']  # name
DATE_LOCATION_R = ['result']  # win_open

#
# These functions take the JSON data keys and does checks to determine
#   how to display the data. They're used in the add_text blocks below
#
def mission_transform(val):
    val0a = val[0]['name']  # get the name
    if val0a is None:
        val = "Unavailable"
    return "Mission:" + val0a[0:29]

def time_transform(val2):
    val2a = val2[0]['win_open']  # get the launch time
    if val2a is None:
        return "When: Unavailable"
#    val2a = "2021-03-09T00:41Z"
    print("\n3Wz val2a :", val2a)
    year = int(val2a[0:4])
    month = int(val2a[5:7])
    day = int(val2a[8:10])
    print("3Wz day :", day)
    hour = int(val2a[11:13])
    print("3Wz val2a hour :", hour)
    min = int(val2a[14:16])

    # not gonna' leep to a conclusion
    if (day - 1) < 1:  # implies march 1st
        if (year % 4) == 0:
            if (year % 100) == 0:
                if (year % 400) == 0:
                    print("\n4/100/400/ {0} is a leap year".format(year))
                    month = 2
                    day = 30
                else:
                    print("\n4/100/ {0} is not a leap year".format(year))
                    month = 2
                    day = 29
            else:
                print("\n4/ {0} is a leap year".format(year))
                month = 2
                day = 30
        else:
            print("\n{0} is not a leap year".format(year))
            month = 2
            day = 29
    else:
        month = 3

    if USE_24HR_TIME:
        if hour < 8:
            day = day - 1  # correct the day
            hour = hour + 24
            hour = hour + int(secrets["urcitytzoffset"])
            print("3Wz 24hr hour < 8 :", hour)
            if hour > 23:
                hour = hour - 24
                print("3Wz 24hr hour-24 :", hour)
        else:
            if hour > 7:
                hour = hour + int(secrets["urcitytzoffset"])
                print("3Wz 24hr hour > 7 :", hour)
        timestring = "%02d:%02d" % (hour, min)
    elif hour > 12:
        timestring = "%d:%02d pm" % (hour-12, min)
    else:
        timestring = "%d:%02d am" % (hour, min)
    timestring = timestring + " " + secrets["urcity"]
    return "%s %d, @ %s" % (months[month-1], day, timestring)

def details_transform(val3):
    val3a = val3[0]['launch_description']  # get the flight info
    if val3a is None or not len(val3a):
        return "Details: To Be Determined"
    return "Details: " + val3a[0:200] + "..." + " Data Courtesy of RocketLaunch.Live"

def take_a_nap(NAP_TIME):
    # get current time from WorldTimeAPI for wakeup after 00:00
    wtapi = magtag.network.fetch(DATA_SOURCE_TIME)
    json_data = wtapi.json()
    unxtym = json_data["unixtime"]
    tymofs = json_data["raw_offset"]

    # compute current time offset in seconds
    current_time = unxtym + tymofs
    hour, minutes, seconds = time.localtime(current_time)[3:6]
    seconds_since_midnight = 60 * (hour * 60 + minutes) + seconds
    # wake up 20 minutes after midnite
    seconds_to_sleep = (24 * 60 * 60 - seconds_since_midnight) + 20 * 60
    print(
        "Sleeping for {} hours, {} minutes".format(
            seconds_to_sleep // 3600, (seconds_to_sleep // 60) % 60
            )
        )
    magtag.exit_and_deep_sleep(NAP_TIME)

# Set up the MagTag with the JSON data parameters
magtag = MagTag(
    url=DATA_SOURCE_ROCKET,
    json_path=(NAME_LOCATION_R,
               DATE_LOCATION_R,
               DETAIL_LOCATION_R)
)

magtag.add_text(
    text_font="/fonts/Lato-Bold-ltd-25.bdf",
    text_position=(10, 15),
    is_data=False
)

# Display heading text below with formatting above
magtag.set_text("Next Rocket Launch")

# Formatting for the mission text
magtag.add_text(
    text_font="/fonts/Arial-Bold-12.pcf",
    text_position=(10, 38),
    text_transform=mission_transform
)

# Formatting for the launch time text
magtag.add_text(
    text_font="/fonts/Arial-12.bdf",
    text_position=(10, 60),
    text_transform=time_transform
)

# Formatting for the details text
magtag.add_text(
    text_font=terminalio.FONT,
    text_position=(10, 94),
    line_spacing=0.8,
    text_wrap=47,     # wrap text at this count
    text_transform=details_transform
)

try:
    # Have the MagTag connect to the internet
    magtag.network.connect()
    # This statement gets the JSON data and displays it automagically
    value = magtag.fetch()
except (ValueError, RuntimeError) as e:
    print("Some error occured, retrying! -", e)

# wait 2 seconds for display to complete
time.sleep(2)
# magtag.exit_and_deep_sleep(TIME_BETWEEN_REFRESHES)
take_a_nap(NAP_TIME)