
#include "ArucoMarkerDetector.hpp"

using namespace cv;
using namespace std;

ArucoMarkerDetector::ArucoMarkerDetector(int argc, char** argv)
{
   run(argc,argv);
}


int ArucoMarkerDetector::detectMarker(const Mat& scene, Mat& cTmk)
{
  int ret = 0;
  
  
//   while(inputVideo.grab()) {
        Mat image, imageCopy;
	scene.copyTo(image);
//         inputVideo.retrieve(image);

        double tick = (double)getTickCount();

        vector< int > ids;
        vector< vector< Point2f > > corners, rejected;
        vector< Vec3d > rvecs, tvecs;

        // detect markers and estimate pose
	/// @WARNING aruco::detectMarkers uses parallel_for_ which creates segmentation fault and Thread switching something ...
        aruco::detectMarkers(image, dictionary, corners, ids, detectorParams, rejected);
	
	Mat rmat;
        if(estimatePose && ids.size() > 0) {
            aruco::estimatePoseSingleMarkers(corners, markerLength, camMatrix, distCoeffs, rvecs,
                                             tvecs);
	    
	    Rodrigues(rvecs, rmat);
	    
	    if (tvecs.size() > 1) 
	    {
	      cout << "[Error] there are wrong detections" << endl;
	      return 1;
	    } else
	      createTransformMat(rmat,Mat(tvecs[0]),cTmk);

	    double currentTime = ((double)getTickCount() - tick) / getTickFrequency();
	    totalTime += currentTime;
	    totalIterations++;
	    if(totalIterations % 30 == 0) {
		cout << "Detection Time = " << currentTime * 1000 << " ms "
		    << "(Mean = " << 1000 * totalTime / double(totalIterations) << " ms)" << endl;
	    }

	    // draw results
	    image.copyTo(imageCopy);
	    if(ids.size() > 0) {
		aruco::drawDetectedMarkers(imageCopy, corners, ids);

		if(estimatePose) {
		    for(unsigned int i = 0; i < ids.size(); i++)
			aruco::drawAxis(imageCopy, camMatrix, distCoeffs, rvecs[i], tvecs[i],
					markerLength * 0.5f);
		}
	    }

	    if(showRejected && rejected.size() > 0)
		aruco::drawDetectedMarkers(imageCopy, rejected, noArray(), Scalar(100, 0, 255));

	    imshow("out", imageCopy);
	    waitKey();
	}
//         char key = (char)waitKey(waitTime);
//         if(key == 27) break;
//     }

  return ret;
}


int ArucoMarkerDetector::run(int argc, char** argv) {
      CommandLineParser parser(argc, argv, keys);
    parser.about(about);

    if(argc < 2) {
        parser.printMessage();
        return 0;
    }

    dictionaryId = parser.get<int>("d");
    showRejected = parser.has("r");
    estimatePose = parser.has("c");
    markerLength = parser.get<float>("l");

    detectorParams = aruco::DetectorParameters::create();
    if(parser.has("dp")) {
        bool readOk = readDetectorParameters(parser.get<string>("dp"), detectorParams);
        if(!readOk) {
            cerr << "Invalid detector parameters file" << endl;
            return 0;
        }
    }
    detectorParams->cornerRefinementMethod = aruco::CORNER_REFINE_SUBPIX; // do corner refinement in markers

    int camId = parser.get<int>("ci");

    String video;
    if(parser.has("v")) {
        video = parser.get<String>("v");
    }

    if(!parser.check()) {
        parser.printErrors();
        return 0;
    }

    Ptr<aruco::Dictionary> dictionary =
        aruco::getPredefinedDictionary(aruco::PREDEFINED_DICTIONARY_NAME(dictionaryId));

    
    if(estimatePose) {
        bool readOk = readCameraParameters(parser.get<string>("c"), camMatrix, distCoeffs);
        if(!readOk) {
            cerr << "Invalid camera file" << endl;
            return 0;
        }
    }

    if(!video.empty()) {
        inputVideo.open(video);
        waitTime = 0;
    } else {
//         inputVideo.open(camId);
//         waitTime = 10;
    }

    totalTime = 0;
    totalIterations = 0;

    return 0;
}


void ArucoMarkerDetector::createTransformMat(const Mat& r, const Mat& t, Mat& T)
{
  T = Mat::eye(4,4,CV_32FC1);
  
  r.copyTo(T(Range(0,3),Range(0,3)));
  t.copyTo(T(Range(0,3),Range(3,4)));
}