import Opaleye
import Data.Profunctor
import Data.Profunctor.Product

user :: Table (Column PGInt8, Column PGText) (Column PGInt8, Column PGText)
user = table "user" $ p2 (tableColumn "id", tableColumn "username")

admin :: Table (Column PGInt8) (Column PGInt8)
admin = table "admin" $ tableColumn "user"

userWithAdmin :: Query (Column PGInt8, Column PGText, Column PGBool)
userWithAdmin = leftJoinF
    (\(a, b) _ -> (a, b, pgBool True))
    (\(a, b) -> (a, b, pgBool False))
    (\(a, _) c -> a .== c)
    (queryTable user)
    (queryTable admin)

{-

> mapM_ putStrLn $ showSql userWithAdmin 
SELECT CASE WHEN ("result2_1_3") IS NULL THEN "result1_0_3" ELSE "result1_0_3" END as "result1_4",
       CASE WHEN ("result2_1_3") IS NULL THEN "result1_1_3" ELSE "result1_1_3" END as "result2_4",
       CASE WHEN ("result2_1_3") IS NULL THEN FALSE ELSE TRUE END as "result3_4"
FROM (SELECT *
      FROM (SELECT *
            FROM
            (SELECT "id0_1" as "result1_0_3",
                    "username1_1" as "result1_1_3",
                    *
             FROM (SELECT *
                   FROM (SELECT "id" as "id0_1",
                                "username" as "username1_1"
                         FROM "user" as "T1") as "T1") as "T1") as "T1"
            LEFT OUTER JOIN
            (SELECT "user0_2" as "result2_0_3",
                    TRUE as "result2_1_3",
                    *
             FROM (SELECT *
                   FROM (SELECT "user" as "user0_2"
                         FROM "admin" as "T1") as "T1") as "T1") as "T2"
            ON
            ("id0_1") = ("user0_2")) as "T1") as "T1"

-}


userWithoutAdmin :: Query (Column PGInt8, Column PGText)
userWithoutAdmin = rmap (\(a, b, c) -> (a, b)) userWithAdmin

{-

> mapM_ putStrLn $ showSql userWithoutAdmin 
SELECT CASE WHEN ("result2_1_3") IS NULL THEN "result1_0_3" ELSE "result1_0_3" END as "result1_4",
       CASE WHEN ("result2_1_3") IS NULL THEN "result1_1_3" ELSE "result1_1_3" END as "result2_4"
FROM (SELECT *
      FROM (SELECT *
            FROM
            (SELECT "id0_1" as "result1_0_3",
                    "username1_1" as "result1_1_3",
                    *
             FROM (SELECT *
                   FROM (SELECT "id" as "id0_1",
                                "username" as "username1_1"
                         FROM "user" as "T1") as "T1") as "T1") as "T1"
            LEFT OUTER JOIN
            (SELECT "user0_2" as "result2_0_3",
                    TRUE as "result2_1_3",
                    *
             FROM (SELECT *
                   FROM (SELECT "user" as "user0_2"
                         FROM "admin" as "T1") as "T1") as "T1") as "T2"
            ON
            ("id0_1") = ("user0_2")) as "T1") as "T1"

-}
