from mpi4py import MPI
import numpy as np
from time import sleep
from adios2 import Stream, Adios, bindings

# MPI
comm = MPI.COMM_WORLD
rank = comm.Get_rank()
size = comm.Get_size()

color = 3231
app_comm = comm.Split(color, rank)
arank = app_comm.Get_rank()
asize = app_comm.Get_size()

# ADIOS MPI Communicator
adios = Adios(app_comm)

# ADIOS IO
io = adios.declare_io("simai")
io.set_engine("SST")
parameters = {
    'RendezvousReaderCount': '1', # options: 1 for sync, 0 for async
    'QueueFullPolicy': 'Block', # options: Block, Discard
    'QueueLimit': '1', # options: 0 for no limit
    'DataTransport': 'MPI', # options: MPI, WAN,  UCX, RDMA
    'OpenTimeoutSecs': '600', # number of seconds SST is to wait for a peer connection on Open()
}
io.set_parameters(parameters)

myArray = np.array([0, 1, 2, 3, 4], dtype=np.int64)
myArray = 10.0 * arank + myArray
nx = len(myArray)
increment = nx * asize * 1.0

# Send some setup data
workflow_steps = 3
with Stream(io, "data_stream", "w", app_comm) as stream:
    for istep in range(workflow_steps):
        stream.begin_step()
        if istep>0: myArray += increment

        stream.write("y", myArray, [asize * nx], [arank * nx], [nx])
        print(f"Simulaiton [{arank}]: sent data = {myArray}", flush=True)
        stream.end_step()



