from mpi4py import MPI
import numpy as np
from adios2 import Stream, Adios, bindings
from time import sleep

# MPI
comm = MPI.COMM_WORLD
rank = comm.Get_rank()
size = comm.Get_size()

color = 3230
app_comm = comm.Split(color, rank)
asize = app_comm.Get_size()
arank = app_comm.Get_rank()

# ADIOS MPI Communicator
adios = Adios(app_comm)

# ADIOS IO
io = adios.declare_io("simai")
io.set_engine("SST")
parameters = {
    'RendezvousReaderCount': '1', # options: 1 for sync, 0 for async
    'QueueFullPolicy': 'Block', # options: Block, Discard
    'QueueLimit': '1', # options: 0 for no limit
    'DataTransport': 'MPI', # options: MPI, WAN,  UCX, RDMA
    'OpenTimeoutSecs': '600', # number of seconds SST is to wait for a peer connection on Open()
}
io.set_parameters(parameters)

# Read setup data
workflow_steps = 3
with Stream(io, "data_stream", "r", app_comm) as stream:
    for istep in range(workflow_steps):
        stream.begin_step()
        # Read training data
        var = stream.inquire_variable("y")
        shape = var.shape()
        count = int(shape[0] / asize)
        start = count * arank
        if arank == asize - 1:
            count += shape[0] % asize
        train_data = stream.read("y", [start], [count])
        print(f'Trainer [{arank}]: received data {train_data}',flush=True)
        stream.end_step()


