package com.zhonghong;

import com.alibaba.fastjson2.*;
import com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.util.TypeUtils;
import com.zhonghong.dto.ExtConfig;
import com.zhonghong.score.BaseScore;
import com.zhonghong.score.FootballScore;
import javafx.util.Pair;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import static com.alibaba.fastjson2.util.TypeUtils.loadClass;

public class Main {

    private static final Filter AUTO_TYPE_FILTER = new Handler(true, new String[]{}, new HashSet<>());

    // 摘至dobbo源码org.apache.dubbo.common.serialize.fastjson2.FastJson2ObjectOutput.writeObject(Object)
    static JSONWriter.Feature[] writeFeatures = {
            JSONWriter.Feature.WriteClassName,
            JSONWriter.Feature.FieldBased,
            JSONWriter.Feature.ErrorOnNoneSerializable, JSONWriter.Feature.ReferenceDetection,
            JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NotWriteDefaultValue,
            JSONWriter.Feature.NotWriteHashMapArrayListClassName, JSONWriter.Feature.WriteNameAsSymbol };

    // 摘至dobbo源码org.apache.dubbo.common.serialize.fastjson2.FastJson2ObjectInput.readObject(Class<T>)
    static JSONReader.Feature[] readerFeatures = {
            JSONReader.Feature.UseDefaultConstructorAsPossible,
            JSONReader.Feature.ErrorOnNoneSerializable,
            JSONReader.Feature.IgnoreAutoTypeNotMatch,
            JSONReader.Feature.UseNativeObject,
            JSONReader.Feature.FieldBased};

    static {
        JSONFactory.setUseJacksonAnnotation(true);
    }


    public static void main(String[] args) {
        BaseScore score = buildScore();
        ExtConfig extConfig = new ExtConfig();
        extConfig.setBaseScore(score);

        byte[] bytes = JSONB.toBytes(
                extConfig,
                writeFeatures
        );
        System.out.println(JSONB.toJSONString(bytes));

        extConfig = JSONB.parseObject(
                bytes,
                ExtConfig.class,
                AUTO_TYPE_FILTER,
                readerFeatures
        );

        System.out.println(JSON.toJSONString(extConfig));
    }

    private static BaseScore buildScore() {
        FootballScore footballScore = new FootballScore();
        footballScore.setFinalScore("1:2");
        footballScore.setFirstPeriodScore(new Pair<>("1", "2"));
        footballScore.setSecondPeriodScore(new Pair<>("1", "3"));
        footballScore.setThirdPeriodScore(new Pair<>("1", "4"));
        return footballScore;
    }

    public static class Handler extends ContextAutoTypeBeforeHandler {
        final Map<String, Class<?>> classCache = new ConcurrentHashMap<>(16, 0.75f, 1);

        final Set<String> disAllowedList;

        final boolean checkSerializable;

        public Handler(
                boolean checkSerializable,
                String[] acceptNames,
                Set<String> disAllowedList) {
            super(true, acceptNames);
            this.checkSerializable = checkSerializable;
            this.disAllowedList = disAllowedList;
        }

        @Override
        public Class<?> apply(String typeName, Class<?> expectClass, long features) {
            Class<?> tryLoad = super.apply(typeName, expectClass, features);

            // 1. in allow list, return
            if (tryLoad != null) {
                return tryLoad;
            }

            // 2. check if in strict mode

            // 3. try load
            Class<?> localClass = loadClassDirectly(typeName);
            if (localClass != null) {
                return localClass;
            }

            // 4. class not found
            return null;
        }

        public Class<?> loadClassDirectly(String typeName) {
            Class<?> clazz = classCache.get(typeName);

            if (clazz == null) {
                clazz = TypeUtils.getMapping(typeName);
            }

            if (clazz == null) {
                clazz = loadClass(typeName);
            }

            if (clazz != null) {
                Class<?> origin = classCache.putIfAbsent(typeName, clazz);
                if (origin != null) {
                    clazz = origin;
                }
            }


            return clazz;
        }
    }
}
