#!/bin/bash
# ad7195_test.sh - Enhanced AD7195 Load Cell Monitor

echo "=== AD7195 Load Cell Weight Monitor ==="
echo "1. Normal Mode"
echo "2. Calibration Mode"
read -p "Select mode (1 or 2): " MODE
read -p "scale Factor(0.000298020 0.000149010 0.000074500 0.000037250 0.000018620 0.000009310 0.000004650 0.000002320): " SCALE_FACTOR
read -p "sampling Feq: " SAMPLE_FREQ
# Configuration
ZERO_OFFSET=1000
CALIBRATION_FACTOR=0.5
#0.000298020 0.000149010 0.000074500 0.000037250 0.000018620 0.000009310 0.000004650 0.000002320
#SCALE_FACTOR=0.000298020

# Setup AD7195
echo 1 > /sys/bus/iio/devices/iio:device0/ac_excitation_en
echo 1 > /sys/bus/iio/devices/iio:device0/bridge_switch_en
echo $SCALE_FACTOR > /sys/bus/iio/devices/iio:device0/in_voltage-voltage_scale
echo $SCALE_FACTOR > /sys/bus/iio/devices/iio:device0/in_voltage_scale
echo $SAMPLE_FREQ > /sys/bus/iio/devices/iio:device0/sampling_frequency

SC3=$(cat /sys/bus/iio/devices/iio:device0/in_voltage_scale)
SC34=$(cat /sys/bus/iio/devices/iio:device0/in_voltage-voltage_scale)
SMFRQ=$(cat /sys/bus/iio/devices/iio:device0/sampling_frequency)

echo " scale-v: $SC3 , scale-vv: $SC34"
echo " sampling_frequency: $SMFRQ"


if [ "$MODE" = "2" ]; then
    echo ""
    echo "=== CALIBRATION MODE ==="
    echo "Step 1: Remove all weight from scale, then press Enter"
    read
    ZERO_RAW=$(cat /sys/bus/iio/devices/iio:device0/in_voltage3-voltage4_raw)
    echo "Zero reading: $ZERO_RAW"
    
    echo ""
    read -p "Step 2: Place known weight (kg): " KNOWN_WEIGHT
    echo "Press Enter after placing the weight"
    read
    FULL_RAW=$(cat /sys/bus/iio/devices/iio:device0/in_voltage3-voltage4_raw)
    echo "Full scale reading: $FULL_RAW"
    
    # Calculate calibration factor
    CALIBRATION_FACTOR=$(echo "$KNOWN_WEIGHT / ($FULL_RAW - $ZERO_RAW)" | bc -l)
    ZERO_OFFSET=$ZERO_RAW
    
    echo ""
    echo "Calibration Results:"
    echo "ZERO_OFFSET=$ZERO_OFFSET"
    echo "CALIBRATION_FACTOR=$CALIBRATION_FACTOR"
    echo ""
    echo "Update these values in your script for future use."
    echo ""
fi

echo "Starting weight monitoring..."
COUNT=0

while true; do
    RAW_VALUE=$(cat /sys/bus/iio/devices/iio:device0/in_voltage3-voltage4_raw)
    RAW_V3=$(cat /sys/bus/iio/devices/iio:device0/in_voltage3_raw)
    RAW_V4=$(cat /sys/bus/iio/devices/iio:device0/in_voltage4_raw)
    WEIGHT=$(echo "($RAW_VALUE - $ZERO_OFFSET) * $CALIBRATION_FACTOR" | bc -l)
    
    COUNT=$((COUNT + 1))
    TIMESTAMP=$(date '+%H:%M:%S')
    
    printf "[%s] #%04d | Raw: %6d | Weight: %8.2f kg| R3: %6d | R4: %6d\n" \
           "$TIMESTAMP" "$COUNT" "$RAW_VALUE" "$WEIGHT" "$RAW_V3" "$RAW_V4"
    sleep 0.1 
done
