﻿using System.Collections.ObjectModel;

namespace SampleRepo;

public partial class MainPage : ContentPage
{
	CarouselView _carouselView;
	CollectionView _collectionView;
	ObservableCollection<string> items = new ObservableCollection<string>
	{
		"Item 1", "Item 2", "Item 3", "Item 4", "Item 5",
		"Item 6", "Item 7", "Item 8", "Item 9", "Item 10"
	};

	public MainPage()
	{
		_collectionView = new CollectionView
		{
			HeightRequest = 200,
			ItemsSource = items,
			ItemTemplate = new DataTemplate(() =>
			{
				Label label = new Label
				{
					FontSize = 32,
					BackgroundColor = Colors.LightGray,
					Padding = 20,
					HorizontalOptions = LayoutOptions.Fill,
					VerticalOptions = LayoutOptions.Fill
				};
				label.SetBinding(Label.TextProperty, ".");
				return label;
			})
		};

		_carouselView = new CarouselView
		{
			HeightRequest = 200,
			Loop = false,
			ItemsSource = items,
			ItemTemplate = new DataTemplate(() =>
			{
				Label label = new Label
				{
					FontSize = 32,
					BackgroundColor = Colors.LightGray,
					Padding = 20,
					HorizontalOptions = LayoutOptions.Fill,
					VerticalOptions = LayoutOptions.Fill
				};
				label.SetBinding(Label.TextProperty, ".");
				return label;
			})
		};

		Button toggleButton = new Button
		{
			Text = "Disable CarouselView and CollectionView"
		};
		toggleButton.Clicked += OnToggleEnabledClicked;

		Grid grid = new Grid
		{
			Padding = 20,
			RowSpacing = 20,
			RowDefinitions =
			{
				new RowDefinition { Height = new GridLength(200) },
				new RowDefinition { Height = new GridLength(200) },
				new RowDefinition { Height = GridLength.Auto }
			}
		};

		grid.Add(_collectionView, 0, 0);
		grid.Add(_carouselView, 0, 1);
		grid.Add(toggleButton, 0, 2);

		Content = grid;
	}

	void OnToggleEnabledClicked(object sender, EventArgs e)
	{
		_carouselView.IsEnabled = !_carouselView.IsEnabled;
		((Button)sender).Text = _carouselView.IsEnabled ? "Disable CarouselView and CollectionView" : "Enable CarouselView and CollectionView";
       _collectionView.IsEnabled = !_collectionView.IsEnabled;	
	}
}